/*
 * Parser.java
 *
 * Created on 29 de Setembro de 2007, 21:04
 **/

 /**
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

package com.bitzi.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;



/**
 *
 * @author David Santiago <demanuel@gmail.com>
 * @TODO This class needs a cleanup once the java regexp improves! :P
 * @Observation Me fail inglish? That's unpossible!
 */
public class Parser {
    
    /** Variable definition **/
    //Extracted stuff and needed 
    private String fileName, fileClassification, lastComment,  inputLine;
    private float fileRating;
    private Vector<String> fileNamesList;
    byte[] info = {0,0,0};//Name, File Ratings, Suggested Filenames
    
    //Connection stuff
    String location;
    URLConnection connection;
    URL url;
    
    //REGEXP stuff - Not used
    Pattern pattern;
    Matcher matcher;
    
    
    /** Creates a new instance of Parser */
    public Parser(String location) {
        this.fileNamesList=new Vector();
        this.setFileClassification("N/A");
        this.setFileRating("+0.0");
        this.setFileName("Not Found In The DataBase");
        
        this.setLocation(location);

        this.parse();

    }
    
    /**
     * Opens a connection via http to the bitzi web page, and extracts the wanted data one by one.
     * Since it reads one line at a time, there is a 'info' variable to check wich data has already
     * been extracted. 
     * This is completely ad-hoc and needs desperately being improved! :)
     */
    
    public void parse()
    {
        try {

            url = new URL(this.getLocation());
            this.connection = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            
            //TODO: ideally this should be done using regexp, but i'm getting trouble so i did this using the easy and ugly way
            
            while ((inputLine = in.readLine()) != null)
            {
                if(info[0]==0) //Name Parsing
                {
                    // I'm not very good at regexp, but java regexp sucks!

                    if(inputLine.contains("<title>"))
                    {
                        int initPosition = inputLine.indexOf("<title>")+"<title>Bitzi Full Details: ".length(), endPosition= inputLine.indexOf("</title>");
                        String name=inputLine.substring(initPosition, endPosition);
                        
                        if(name.equals("nt"))
                            break;
                        else
                            this.setFileName(name);
                        
                        
                        info[0]=1;
                    }
                }
                else
                    if(info[1]==0)//File Ratings Parsing
                    {
                        if(inputLine.contains("Media Sources"))
                            info[1]=1;
                        else
                            if(inputLine.contains("class=\"G\"") || inputLine.contains("class=\"R\""))
                            {
                                int initPosition = inputLine.indexOf("class=")+"class=\"G\">".length(), endPosition= inputLine.indexOf("</span>");
                                StringTokenizer tokens= new StringTokenizer(inputLine.substring(initPosition, endPosition), "\"");
                                this.setFileRating(tokens.nextToken());
                                this.setFileClassification(tokens.nextToken());
                                
                                inputLine=in.readLine();
                                setLastComment(inputLine);//TODO
                                
                                
                                info[1]=1;
                            }
                    }
                    else
                        if (info[2]==0)// Suggested Filenames Parsing
                        {
                            if(inputLine.contains("<li>"))
                            {
                                while(inputLine.contains("<li>")) //yes! It's only a line with all the suggested names!
                                {
                                    inputLine=inputLine.substring(inputLine.indexOf("<li>")+"<li>".length());
                                    this.addFileName(inputLine.substring(0,inputLine.indexOf("</li>")).replaceAll("<WBR>", "").replaceAll("</WBR>",""));
                                }

                                info[2]=1;
                                break;
                            }

                        }
                        else //There is nothing more to parse
                            break;
            }
            
            in.close();
            
        } catch (MalformedURLException ex) {
            
            ex.printStackTrace();
        } catch (IOException ex) {
            
            ex.printStackTrace();
        }
    }

    
    /**
    * @return the name of the selected file.
    */
    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /**
    * @return a string corresponding to the filename classification.
    */
    public String getFileClassification() {
        return fileClassification;
    }

    public void setFileClassification(String fileClassification) {
        this.fileClassification = fileClassification;
    }

    /**
     * @return the file rating
     */
    public float getFileRating() {
        return fileRating;
    }

    public void setFileRating(String sFileRating) {
        
        String[] number=sFileRating.split("\\.");

        int firstPart=Integer.parseInt(number[0].substring(1).trim()), secondPart=Integer.parseInt(number[1].trim());
        
        this.fileRating=firstPart+(float)(secondPart/10.0);
        
        if(sFileRating.charAt(0)=='-')
            this.fileRating*=-1;
    }

    public void addFileName(String name)
    {
        fileNamesList.add(name);
    }
    
    /**
     * @return a list containing the known filename for the selected file
     */
    public Vector<String> getFileNamesList() {
        return fileNamesList;
    }

    /**
     * @return the last comment add to the selected file in the bitzi database
     */
    public String getLastComment() {
        return lastComment;
    }

    public void setLastComment(String lastComment) {
        this.lastComment = lastComment;
    }

    /**
     * @return the url of the selected file to the bitzi database
     */
    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }
    
}
